/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 * Copyright (c) 2012, NVIDIA CORPORATION.  All rights reserved.
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _BASEWINDOWSYSTEM_H_
#define _BASEWINDOWSYSTEM_H_

#include "Scene.h"

typedef enum dumpOutputType
{
    DUMP_RAW = 0,
    DUMP_BMP = 1,
    DUMP_UNKNOWN
} DumpOutputType;

class BaseWindowSystem
{
public:
    BaseWindowSystem(Scene* pScene, InputManager* pInputManager)

    : m_pInputManager(pInputManager)
    , m_pScene(pScene)
    , m_forceComposition(false)
    {
    }

    virtual ~BaseWindowSystem()
    {
    }

    virtual bool start(int maxIterationDurationInMS) = 0;
    virtual void stop() = 0;
    virtual void allocatePlatformSurface(Surface *surface) = 0;
    virtual bool processVnctouchevent(int screenID,int x,int y,int down) = 0;
    virtual bool processVncmouseevent(int screenID,int x,int y,int buttonmask) = 0;
    virtual bool processVnckeyboardevent(int screenID,unsigned int keycode, int down) = 0;
    virtual void doScreenShot(std::string fileName, const uint screen_id) = 0;
    virtual void doScreenShotOfLayer(std::string fileName, const uint id) = 0;
    virtual void doScreenShotOfSurface(std::string fileName, const uint id, const uint layer_id) = 0;
    virtual InputManager* addInputManager(char *seatName) 
    {
        (void)seatName;
        return NULL;
    }
    virtual void finishFrame() { }
    virtual void chkForDrawPending() { }
    virtual int doRepaintTimer(int screenID) = 0;

protected:
    virtual void ClearDamage(int screenID = -1);
    InputManager* m_pInputManager;

public:
    Scene* m_pScene;
    bool m_forceComposition;
};

#endif /* _BASEWINDOWSYSTEM_H_ */
